/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ninni.spawn.client.model.AnglerFishModel;
import com.ninni.spawn.client.renderer.entity.feature.BioluminescenceLayer;
import com.ninni.spawn.entity.AnglerFish;
import com.ninni.spawn.registry.SpawnEntityModelLayers;
import java.util.function.Predicate;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnglerFishRenderer<E extends AnglerFish>
extends MobRenderer<E, AnglerFishModel<E>> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("spawn", "textures/entity/angler_fish/angler_fish.png");
    public static final ResourceLocation TEXTURE_DEFLATED = new ResourceLocation("spawn", "textures/entity/angler_fish/angler_fish_deflated.png");
    private final AnglerFishModel<E> normalModel;
    private final AnglerFishModel<E> deflatedModel;

    public AnglerFishRenderer(EntityRendererProvider.Context context) {
        super(context, null, 0.3f);
        this.m_115326_((RenderLayer)new BioluminescenceLayer<AnglerFish>((RenderLayerParent<AnglerFish, AnglerFishModel<AnglerFish>>)this, Predicate.not(AnglerFish::isDeflated)));
        this.normalModel = this.createModel(context, SpawnEntityModelLayers.ANGLER_FISH);
        this.f_115290_ = this.normalModel;
        this.deflatedModel = this.createModel(context, SpawnEntityModelLayers.ANGLER_FISH_DEFLATED);
    }

    public void render(E mob, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        this.f_115290_ = ((AnglerFish)mob).isDeflated() ? this.deflatedModel : this.normalModel;
        super.m_7392_(mob, f, g, poseStack, multiBufferSource, i);
    }

    public ResourceLocation getTextureLocation(E entity) {
        return ((AnglerFish)entity).isDeflated() ? TEXTURE_DEFLATED : TEXTURE;
    }

    public AnglerFishModel<E> createModel(EntityRendererProvider.Context context, ModelLayerLocation layer) {
        return new AnglerFishModel(context.m_174023_(layer));
    }
}

